package dataWorkshop.gui.data.encoding;

import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.SwingConstants;

import dataWorkshop.data.DataEncoding;
import dataWorkshop.data.encoding.AbstractNumberEncoding;

/**
 * <p>
 * DataWorkshop - a binary data editor 
 * <br>
 * Copyright (C) 2000, 2004  Martin Pape (martin.pape@gmx.de)
 * <br>
 * <br>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * <br>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * <br>
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </p>
 */
public abstract class AbstractNumberConfigurationPane extends DataEncodingConfigurationPane {
    
    JCheckBox littleEndianBox;
    
    public AbstractNumberConfigurationPane() {
        littleEndianBox = new JCheckBox("LittleEndian");
        littleEndianBox.setHorizontalTextPosition(SwingConstants.LEADING);
        littleEndianBox.addActionListener(this);
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(Box.createRigidArea(new Dimension(6, 0)));
        add(littleEndianBox);
    }
    
     public void setEnabled(boolean enabled) {
        littleEndianBox.setEnabled(enabled);
    }
    
    public boolean isLittleEndian() {
        return littleEndianBox.isSelected();
    }
    
    public void setDataEncoding(DataEncoding converter) {
        littleEndianBox.setSelected(((AbstractNumberEncoding) converter).isLittleEndian());
    }
}
